package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.network.Handler12UpdateBlock;

import java.util.ArrayList;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

import org.lwjgl.input.Mouse;

public class GuiChooseBlocksToBreak extends GuiScreen {
	
	EntityClone clone;
	
	GuiScreen parent;
	
	public GuiChooseBlocksToBreak(EntityClone clone, GuiScreen parent){
		this.clone = clone;
		this.parent = parent;
	}

	ArrayList<Long> visibleEntries = new ArrayList<Long>();
	
	GuiSlotChooseBlocksToBreak slot;
	
	@Override
	public void drawScreen(int par1, int par2, float par3) {
		slot.drawScreen(par1, par2, par3);
		search.drawTextBox();
		super.drawScreen(par1, par2, par3);
	}

	@Override
	protected void keyTyped(char par1, int par2) {
		if(par2 == 1){
			mc.displayGuiScreen(parent);
		}else{
			if(!search.isFocused()){
				search.setFocused(true);
			}
		}
		search.textboxKeyTyped(par1, par2);
	}

	
	public void onRemove(long merged) {
		new Handler12UpdateBlock(clone.entityId, false, false, merged).sendToServer();
	}
	
	public void onAdd(long merged) {
		new Handler12UpdateBlock(clone.entityId, true, false, merged).sendToServer();
	}
	
	
	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}

	GuiTextFieldClearable search = null;
	
	@Override
	public void initGui() {
		slot = new GuiSlotChooseBlocksToBreak(clone, this);
		slot.registerScrollButtons(0, 1);
		for(int a = 0; a < allEntries.size(); a++){
			visibleEntries.add(allEntries.get(a));
		}
		search = new GuiTextFieldClearable(mc.fontRenderer, width/2 - 205, 5, 200, 20);
		buttonList.add(new GuiButton(2, width/2 + 5, 5, 200, 20, "Un Select All"));
		buttonList.add(new GuiButton(3, width/2 - 205, height-60, 200, 20, "Select All Ores"));
		buttonList.add(new GuiButton(4, width/2 + 5, height-60, 200, 20, "Select All Logs"));
		buttonList.add(new GuiButton(5, (width-150)/2, height-30, 150, 20, "Back"));
	}
	

	@Override
	protected void mouseClicked(int par1, int par2, int par3) {
		search.mouseClicked(par1, par2, par3);
		super.mouseClicked(par1, par2, par3);
	}

	String lastText = "";
	boolean lastClicked = false;
	@Override
	public void updateScreen() {
		if(!lastText.equals(search.getText())){
			lastText = search.getText();
			updateValuesBySearch(lastText);
		}
		search.updateCursorCounter();
		if(Mouse.getEventButtonState()){
			if(Mouse.getEventButton() == 1 && !lastClicked){
				if(search.isFocused()){
					search.setText("");
				}else{
			        int var1 = Mouse.getEventX() * this.width / this.mc.displayWidth;
			        int var2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
			        if(search.isInRange(var1, var2)){
			        	search.setFocused(true);
			        }
				}
			}
			lastClicked = true;
		}else{
			lastClicked = false;
		}
	}
	
	public void updateValuesBySearch(String param){
		visibleEntries.clear();
		if(param.equals("")){
			for(int a = 0; a < allEntries.size(); a++){
				visibleEntries.add(allEntries.get(a));
			}
		}else{
			String compare = param.toLowerCase();
			for(int a = 0; a < allEntries.size(); a++){
				long entry = allEntries.get(a);
				if(getBlockName(entry).toLowerCase().contains(compare)){
					visibleEntries.add(entry);
				}
			}
		}
	}

	@Override
	protected void actionPerformed(GuiButton gb) {
		if(gb.id == 2){
			for(int a = 0; a < allEntries.size(); a++){
				clone.options.removeBlockToBreak(allEntries.get(a));
			}
			updateAllToServer();
		}else if(gb.id == 3){
			for(int a = 0; a < allEntries.size(); a++){
				long entry = allEntries.get(a);
				Block block = getBlock(entry);
				if(block != null && (block instanceof BlockOre || block instanceof BlockRedstoneOre)){
					clone.options.addBlockToBreak(entry);
				}
			}
			updateAllToServer();
		}else if(gb.id == 4){
			for(int a = 0; a < allEntries.size(); a++){
				long entry = allEntries.get(a);
				Block block = getBlock(entry);
				if(block != null && (block instanceof BlockLog)){
					clone.options.addBlockToBreak(entry);
				}
			}
			updateAllToServer();
		}else if(gb.id == 5){
			mc.displayGuiScreen(parent);
		}
	}
	
	public void updateAllToServer(){
		new Handler12UpdateBlock(clone.entityId, true, true, clone.options.getAllBlocks()).sendToServer();
	}



	static{
		getAllValidBlocks();
	}

	static ArrayList<Long> allEntries;
	
	private static void getAllValidBlocks() {
		if(allEntries == null){
			allEntries = new ArrayList<Long>();
		}
//		System.out.println(Block.blocksList.length);
		for(int a = 0; a < Block.blocksList.length; a++){
			Block block = Block.blocksList[a];
			if(block != null && block.blockMaterial != Material.air){
				ArrayList<ItemStack> subTypes = new ArrayList<ItemStack>();
				block.getSubBlocks(a, null, subTypes);
				if(block.blockHardness == -1){
					continue;
				}
				Material mat = block.blockMaterial;
				if(mat != null){
					if(mat.isLiquid()){
						continue;
					}
				}
				if(block instanceof BlockCrops || block.blockID == Block.crops.blockID){
					allEntries.add(merge(block.blockID, 7));
				}else{
					for(int b = 0; b < subTypes.size(); b++){
						ItemStack stack = subTypes.get(b);
						if(stack != null){
							if(stack.getItem() != null && stack.getDisplayName() != null && !stack.getDisplayName().equals("") && stack.getDisplayName().length() > 0){
								allEntries.add(merge(stack.itemID, stack.getItemDamage()));
							}
						}
					}
				}
			}
		}
	}

	public Minecraft getMc() {
		return mc;
	}
	
	
	public static Block getBlock(long merged){
		int id = getId(merged);
		int meta = getMeta(merged);
		if(id > 0 && id < Block.blocksList.length){
			return Block.blocksList[id];
		}
		return null;
	}
	
	public static String getBlockName(long merged){
		int id = getId(merged);
		int meta = getMeta(merged);
		if(id > -1 && id < Block.blocksList.length){
			ItemStack stack = new ItemStack(id, 1, meta);
			return stack.getDisplayName();
		}
		return "\2474An unknown block?";
	}
	
	public static long merge(int id, int meta){
		long value = id;
		value |= ((long)meta) << 32;
		return value;
	}
	
	public static int getMeta(long merged){
		return (int)((merged >> 32) & 0xffffffff);
	}
	
	public static int getId(long merged){
		return (int)(merged & 0xffffffff);
	}
	
}
